/*------------------------------------------------------------------------------*
 *	File Name: 	ocGDI.h									 						*
 *	Purpose:	GDI C functions and types									   	*
 *				This header is used in OUtl, Nlsf and OC						*
 *  Creation:	4-5-04, TD														* 
 *  	Copyright Originlab Corp. 2003, 2004, 2005								*
 *	Modification log	                                                        *
 *------------------------------------------------------------------------------*/      


#ifndef _OCGDI_H_
#define _OCGDI_H_

#ifdef  _MSC_VER	   //VC
#ifdef __cplusplus 
extern "C" {
#endif// __cplusplus 
#else //_MSC_VER
	#pragma dll(@OUTL)
#endif	//!_MSC_VER


typedef	struct {
	SHORT	left;	// SHORT to make it 16bit
	SHORT	top;
	SHORT	right;
	SHORT	bottom;
}	RECT16;


typedef	struct {
	DWORD   key;
	USHORT  hmf;	// USHORT to make it 16bit
	RECT16  bbox;
	WORD    inch;
	DWORD   reserved;
	WORD    checksum;
}	METAFILEHEADER;

#define		SIZEOFMETAFILEHEADER	22	 // needed because 

/**
	get_packed_metafile, creates a metafile from packaged data
	Parameters:
		lpcszPackedFileName	=Name of the package file with full path
		lpcszKey = A string key used for unpacking
		prectBoundingBox = The bounding box of the Metafile, as saved in the FileHeader
	Return:
		returns a HMETAFILE which can be placed. The handle must be destroyed by user by calling DeleteMetaFile 
	Example:
		// function to create an XML file from packed metafile of NLSF
		bool CreatPictTreeUsingNLSFPreviewPictures(string strFilename = "MyTest.xml", string strFuncName ="expdecy3")
		{
			// the following 2 files hold many metafile images for NLSF functions
			string strEquationGroupFile = "fgroup.oqs";
			string strCurveGroupFile = "fgroup.ocs";

			Tree TreePicts;
			
			HMETAFILE hmf;
			RECT16 rect;
			
			
			string strPathName = GetAppPath(TRUE);
			string strPackedPictName = strPathName + strEquationGroupFile;
			
			hmf = get_packed_metafile(strPackedPictName, strFuncName, &rect);
			
			PictureHolder pictHold;
			if(NULL == hmf || !pictHold.CreateFromMetafile(hmf, rect.right, rect.bottom, TRUE))
				return false;

			// if we get this far, then things are looking good
			TreePicts.Pict1.pict =  pictHold;
			
			strPackedPictName = strPathName + strCurveGroupFile;
			hmf = get_packed_metafile(strPackedPictName, strFuncName, &rect);
			if(hmf)
			{
				pictHold.CreateFromMetafile(hmf, rect.right, rect.bottom, TRUE);
				TreePicts.Pict2.pict =  pictHold;
			}
			string strTreeName = GetAppPath() + strFilename;
			TreePicts.Save(strTreeName);
			return true;
		}
	See Also: 
		load_metafile, get_packed_enhanced_metafile, load_enhanced_metafile, get_packed_bitmap, load_dib, DeleteMetaFile, 
*/

HMETAFILE		get_packed_metafile(LPCSTR lpcszPackedFileName, LPCSTR lpcszKey, RECT16 *prectBoundingBox);
/**
	load_metafile, Loads a metafile from file
	Parameters:
		lpcszFilePath	=Name of the file with full path
		prectBoundingBox = The bounding box of the Metafile, as saved in the FileHeader
	Return:
		returns a HMETAFILE which can be placed. The handle must be destroyed by user by calling DeleteMetaFile 
	See Also: 
		get_packed_metafile, get_packed_enhanced_metafile, load_enhanced_metafile, get_packed_bitmap, load_dib, DeleteMetaFile, 
*/
HMETAFILE		load_metafile(LPCTSTR lpcszFilePath, RECT16 *prectBoundingBox);
/**
	get_packed_enhanced_metafile, creates an enhanced metafile from packaged data
	Parameters:
		lpcszPackedFileName	=Name of the package file with full path
		lpcszKey = A string key used for unpacking
	Return:
		returns a HENHMETAFILE , this should be deleted by calling DeleteEnhMetaFile
	See Also: 
		get_packed_metafile, load_metafile, load_enhanced_metafile, get_packed_bitmap, load_dib,  DeleteEnhMetaFile
*/
HENHMETAFILE	get_packed_enhanced_metafile(LPCSTR lpcszPackedFileName, LPCSTR lpcszKey);
/**
	load_enhanced_metafile, Loads an enhanced metafile from file
	Parameters:
		lpcszPackedFileName	=Name of the file with full path
		lpcszKey = A string key used for unpacking
	Return:
		returns a HENHMETAFILE , this should be deleted by calling DeleteEnhMetaFile
	See Also: 
		get_packed_metafile, load_metafile, get_packed_enhanced_metafile, get_packed_bitmap, load_dib,  DeleteEnhMetaFile
*/
HENHMETAFILE	load_enhanced_metafile(LPCTSTR lpcszFilePath);
/**
	get_packed_bitmap, Loads a Bitmap from package data file
	Parameters:
		lpcszPackedFileName	=Name of the package file with full path
		lpcszKey = A string key used for unpacking
	Return:
		returns a HBITMAP. This object must be deleted by calling DeleteObject
	See Also: 
		get_packed_metafile, load_metafile, get_packed_enhanced_metafile, load_enhanced_metafile, load_dib,  DeleteObject
*/
HBITMAP			get_packed_bitmap(LPCSTR lpcszPackedFileName, LPCSTR lpcszKey);

/**
	load_dib, Loads a Device Independant Bitmap a file
	Parameters:
		lpcszPackedFileName	=Name of the package file with full path
	Return:
		returns a HDIB. This object must be deleted by calling GlobalFree
	See Also: 
		get_packed_metafile, load_metafile, get_packed_enhanced_metafile, load_enhanced_metafile, get_packed_bitmap,  DeleteObject
*/
HDIB			load_dib(LPCSTR lpcszDIBFilename);


HBITMAP			DDB_from_DIB(HDIB);

#ifdef _MSC_VER	   //VC
#ifdef __cplusplus 
}
#endif// __cplusplus 
#endif	//!_MSC_VER

#endif//_OCGDI_H_
